; Diagnostic ROM part 1
;Test 1  RAMTEST
; 
; Author Dwight Elvey
;
; Converted to standard assembler Hans Otten, 2025
;
; Standard Defines KIM-1
;
; I/O in 6530-002
;
SAD     =     $1740             ; 6530 A DATA
PADD    =     $1741             ; 6530 A DATA DIRECTION
SBD     =     $1742             ; 6530 B DATA
PBDD    =     $1743             ; 6530 B DATA DIRECTION
CLK1T   =     $1744             ; DIV BY 1 TIME
CLK8T   =     $1745             ; DIV BY 8 TIME
CLK64T  =     $1746             ; DIV BY 64 TIME
CLKKT   =     $1747             ; DIV BY 1024 TIME
CLKRDI  =     $1747             ; READ TIME OUT BIT
CLKRDT  =     $1746             ; READ TIME
;
;
; I/O in 6530-002
;
SAD1     =     $1700             ; 6530 A DATA
PADD1    =     $1701             ; 6530 A DATA DIRECTION
SBD1     =     $1702             ; 6530 B DATA
PBDD1    =     $1703             ; 6530 B DATA DIRECTION
CLK1T1   =     $1704             ; DIV BY 1 TIME
CLK8T1   =     $1705             ; DIV BY 8 TIME
CLK64T1  =     $1706             ; DIV BY 64 TIME
CLKKT1   =     $1707             ; DIV BY 1024 TIME
CLKRDI1  =     $1707             ; READ TIME OUT BIT
CLKRDT1  =     $1706             ; READ TIME

; Zero page 6530--002
;
;
INH     =     $F9               ; INPUT BUFFER
POINTL  =     $FA               ; LSB OF OPEN CELL
POINTH  =     $FB               ; MSB OF OPEN CELL
CNT		=	  $FC				; counter
;
; KIM-1 Routines
;
SCANDS  = $1F1F
KEYIN   = $1F40
GETKEY  = $1F6A
;
;Test 1  RAMTEST
; Switch setting:
;  DB on
;  --
;  S0 off
;  S1 on
;  S2 on
;  S3 on
; This test does a simple stuck at test of the RAM by writing and
; reading 055H and 0FFH to each location in the 2102 RAM array. 
; A passing indication is that the Green LED will blink at about 1
; seconds rate for 8 time then on the 9th it will stay lit.
; Should there be a failure the Green LED will blink out the failing
; bit number. A 1 second blink indicates a good bit and a short blink
; indicates a failed bit. After the 8th blink it will stay unlit.
; If all the bits fail it may be an address decoder problem.
; A single bit failure is likely a single RAM or the bus buffer.
; The blink code starts with bit D0 and blinks through to D7.
; This test does not test or use the 6530/2 RAM for vaiables during the 
; test, other than the RAM it test. It only runs
; in the processor's internal registers. This is not easy to do
; for a 6502. This is the reason it doesn't also indicate the failed
; address as well as the bit. This would likely need the variable space
; that is under test.
; Once this test passes, later test will assume that the RAM
; on Page0 and Page1 are functional and use them as most 6502 programs
; do.
; There are still possible address errors that RAMs can have.
; This test is initiated by the RS reset button on the keyboard.
; As an example, a long-long-short-long-long-long-long-long
; blink code would indicat that bit D2 was failing. In other
; words the blink code is D0 first to D7 last. With the board
; such that the key board is on the lower right, the RAM
; chips blink from top to bottom for the blink codes. Each blink is
; one RAM chip position.
; debug code for KIM-1
; RAMTEST checks the first 1K of 2102 type RAM
; if there is an error, it will bink out the failure
; LSB first. A short blink means that bit is good.
; A long blink indicated that bit bad.
; The long blink is about 1 second. The short one
; is clearly short. If there are no failing bits
; the LED comes on steady. If there is any failure,
; you get 8 blinks and then the LED is off so there
; is no question of the meaning of the LED.
; Sorry the test doesn't give the address but it isn't needed
; because all ot the bits are from single RAM chips
; and buss buffers. Any failure of a single bit means
; either the buffer is bad or the RAM for that bit is bad.
; The address isn't needed to identify the RAM
; bit failing although it would be nice to know if it
; failed all the bits or just one bit of many. Since
; this test has to run with no RAM, there just isn't
; enough storage to keep that information and display it.
; The processor only has A, X, Y and stack pointer. The
; stack pointer is only useful when not using the X pointer.
	.ORG $0C00
RESET
; One can't use page zero yet so there is not indirect
; addressing through a vraiable. One has to use absolute
; address for each of the 4 pages

          CLD
          LDX #$00			; fill memory $0000-$3FF with $55
          LDA #$55
L0C05     STA $0300,X
          INX
          BNE L0C05
L0C0B     STA $0200,X
          INX
          BNE L0C0B
L0C11     STA $0100,X
          INX
          BNE L0C11
L0C17     STA $00,X
          INX
          BNE L0C17
; READS $55 AND LOAD $AA
; Note the repeated code for the 4 ea 256 byte areas		  
          LDY #$AA			; next write patteern
          TYA		
L0C1F     LSR A				; switch t $55	
          EOR $0300,X		; test 0300 page
          BEQ L0C28
          JMP ERROR			; jump to error if not $55

L0C28     TYA
          STA $0300,X
          INX
          BNE L0C1F
L0C2F     LSR A				; start with $AA
          EOR $0200,X		; test 0200 page
          BEQ L0C38
          JMP ERROR			; Not $55
 
L0C38     TYA
          STA $0200,X
          INX
          BNE L0C2F
		  
L0C3F     LSR A				; begin with $55
          EOR $0100,X		; test 0100 page
          BEQ L0C48
          JMP ERROR			; Not $55

L0C48     TYA
          STA $0100,X
          INX
          BNE L0C3F			; not $55
		  
L0C4F     LSR A				; test zeropage
          EOR $00,X
          BEQ L0C57
          JMP ERROR

L0C57     TYA
          STA $00,X
          INX
          BNE L0C4F
          LDY #$AA
L0C5F     TYA
          EOR $0300,X
          BEQ L0C68
          JMP ERROR

L0C68     INX
          BNE L0C5F
L0C6B     TYA
          EOR $0200,X
          BEQ L0C74
          JMP ERROR

L0C74     INX
          BNE L0C6B
L0C77     TYA
          EOR $0100,X
          BEQ L0C80
          JMP ERROR

L0C80     INX
          BNE L0C77
L0C83     TYA
          EOR $00,X
          BEQ L0C8B
          JMP ERROR

L0C8B     INX
          BNE L0C83
          LDA #$00			; if we get this far no error was found
          JMP ERROR

HERE1
		.FILL (ERROR - HERE1)&$FFF, 0

		  
		  .ORG $0D00
;		  
ERROR
          LDX #$08		; loop 8 time for dail bit
L0D02     TXS
          LDY #$00		; set on time 1 sec
          LDX #$00
          STY $1000		; flash status LED off
L0D0A     LDX #$00
L0D0C     NOP
          NOP
          NOP
          NOP
          INX
          BNE L0D0C
          INY
          BNE L0D0A
          LDY #$1B
          STY $1000		; flash status LED on
          LSR A
          BCS L0D23		; test bit
          LDY #$00		; do full 1 sec
          JMP $0D25
L0D23     ADC #$7F		; restore bit to MSB
L0D25     NOP
          NOP
          NOP
          NOP
          DEX
          BNE L0D25
          DEY
          BNE L0D25
          TSX
          DEX
          BNE L0D02
          STX $1000		; flash status LED off
L0D36     LDX #$00
L0D38     NOP
          NOP
          NOP
          NOP
          INX
          BNE L0D38
          INY
          BNE L0D36
          CMP #$00
          BNE L0D4A
          DEY
          STY $1000		; flash status LED off
L0D4A     JMP L0D4A
;
HERE2
		.FILL (GO-HERE2), 0
		.ORG $0E00
		
; BAGELS First book of KIM		

GO	      INC $16
          JSR KEYIN
          BNE GO
          CLD
L0E08     LDA #$0A		; 10 guesses
          STA $18
          LDA #$03		; four mystery codes
          STA $10
L0E10     SEC			; one plus
          LDA $13
          ADC $16		; random numbers
          ADC $17
          STA $12
          LDX #$04
L0E1B     LDA $12,X
          STA $13,X
          DEX
          BPL L0E1B
          LDX $10
          LDY #$C0		; divide by 6
          STY $11
          LDY #$06
L0E2A     CMP $11
          BCC L0E30
          SBC $11
L0E30     LSR $11
          DEY
          BNE L0E2A
          CLC
          ADC #$0A		; random value A to F
          STA $00,X
          DEC $10
          BPL L0E10
L0E3E     DEC $18
          BMI L0EBC
          LDA #$00
          LDX #$0C
L0E46     STA $04,X		; clear from window
          DEX
          BPL L0E46
;
; wait for key depressed
;		  
L0E4B     JSR SHOW
          BEQ L0E4B
          JSR SHOW
          BEQ L0E4B
          LDA $08
          BEQ L0E61
          AND #$60
          EOR #$60
          BEQ L0E08
          BNE L0E3E
L0E61     JSR $1F6A
          CMP #$10
          BCS L0E4B
          CMP #$0A
          BCC L0E4B
          TAY
          LDX $10
          INC $10
          LDA $1FE7,Y
          STA $04,X
          TYA
          CMP $00,X
          BNE L0E7E
          INC $0E
          TXA
L0E7E     STA $0A,X
          LDA $07
          BEQ L0EB5
          LDY #$03
L0E86     LDA $000A,Y
          AND #$18
          BEQ L0E9F
          LDA $0000,Y
          LDX #$03
L0E92     CMP $0A,X
          BEQ L0E9B
          DEX
          BPL L0E92
          BMI L0E9F
L0E9B     INC $0F
          ASL $0A,X
L0E9F     DEY
          BPL L0E86
          LDX #$01
L0EA4     LDY $0E,X
          LDA $1FE7,Y
          STA $08,X
          DEX
          BPL L0EA4
L0EAE     JSR SHOW
          INC $0F
          BNE L0EAE
L0EB5     JSR $0ECE
          BNE L0EB5
          BEQ L0E4B
;
; ten guesses made show answer
;		  
L0EBC     LDX #$03
L0EBE     LDY $00,X
          LDA $1FE7,Y
          STA $04,X
          DEX
          BPL L0EBE
          LDA #$E3
          STA $08
          BNE L0EAE
;		  
;	
SHOW				  
          LDY #$13		; display and test keyboard
          LDX #$05
          LDA #$7F
          STA $1741
L0ED7     LDA $04,X
          STA $1740
          STY $1742
L0EDF     INC $11
          BNE L0EDF
          DEY
          DEY
          DEX
          BPL L0ED7
          JSR KEYIN
          RTS


HEREV
		.FILL (VECTOR - HEREV)&$FFF, 0

;
; Reset vectors
;	

		  .ORG $FFFA
VECTOR		  
          .BYTE RESET&255
          .BYTE RESET/256
          .BYTE RESET&255
          .BYTE RESET/256
          .BYTE RESET&255
          .BYTE RESET/256
		 .END